if unsupported then return end

-- models
E_MODEL_FLOOD = smlua_model_util_get_id("flood_geo")
E_MODEL_CTT = smlua_model_util_get_id("ctt_geo") -- easter egg in the distance
E_MODEL_LAUNCHPAD = smlua_model_util_get_id("launchpad_geo")
E_MODEL_HIDDENFLAG = smlua_model_util_get_id("hiddenflag_geo")
E_MODEL_UP_PLATFORM1 = smlua_model_util_get_id("up_platform_geo")
E_MODEL_UP_STALAGMITE = smlua_model_util_get_id("stalagmite_geo")
E_MODEL_EGGRT = smlua_model_util_get_id("eggrt_geo")
E_MODEL_BASE = smlua_model_util_get_id("base_geo")
E_MODEL_TROLLFACE = smlua_model_util_get_id("trollface_geo")
E_MODEL_BLOOD = smlua_model_util_get_id("blood_geo")

-- collisions
local COL_LAUNCHPAD = smlua_collision_util_get("launchpad_collision")
local COL_BASE = smlua_collision_util_get("base_collision")
local COL_UP_PLATFORM1 = smlua_collision_util_get("up_platform_collision")

-- localize functions to improve performance
local get_environment_region,set_environment_region,set_override_far,cur_obj_scale,cur_obj_init_animation,bhv_pole_base_loop,nearest_mario_state_to_object,play_mario_jump_sound,set_mario_action,spawn_non_sync_object,mario_set_forward_vel,vec3f_set,load_object_collision_model,obj_mark_for_deletion,network_is_server,obj_check_hitbox_overlap,obj_has_behavior_id = get_environment_region,set_environment_region,set_override_far,cur_obj_scale,cur_obj_init_animation,bhv_pole_base_loop,nearest_mario_state_to_object,play_mario_jump_sound,set_mario_action,spawn_non_sync_object,mario_set_forward_vel,vec3f_set,load_object_collision_model,obj_mark_for_deletion,network_is_server,obj_check_hitbox_overlap,obj_has_behavior_id

-- camera settings

camera_romhack_allow_dpad_usage(1)

--- @param o Object
local function bhv_water_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    o.oAnimState = gLevels[gGlobalSyncTable.level].type	

    o.header.gfx.skipInViewCheck = true

    o.oFaceAnglePitch = 0
    o.oFaceAngleRoll = 0
end

--- @param o Object
local function bhv_trollface_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
	o.header.gfx.node.flags = o.header.gfx.node.flags | GRAPH_RENDER_BILLBOARD
	o.header.gfx.skipInViewCheck = true
    o.hitboxRadius = 125
    o.hitboxHeight = 125
	cur_obj_scale(0.5)
end

--- @param o Object
local function bhv_trollface_loop(o)
    local m = gMarioStates[0]
    if o.oTimer > 120 then
        local player = nearest_player_to_object(o)
        local pmario = nearest_living_mario_state_to_object(o) -- line 50
        if pmario ~= nil then
            obj_rotate_towards_point(o, pmario.pos, 0,0,0,0)
            o.oForwardVel = 15 * (dist_between_objects(o, player) / 400)
            obj_compute_vel_from_move_pitch(o.oForwardVel)
            obj_move_xyz_using_fvel_and_yaw(o)
        end
    end

    o.oGraphYOffset = math.sin(o.oTimer * 0.2) * 30

	if dist_between_objects(o, m.marioObj) < 75 and o.oTimer > 120 then
	    network_play(sTrolldie, m.pos, 1.2, m.playerIndex)
        m.health = 0xff
	end
end

id_bhvTrollface = hook_behavior(nil, OBJ_LIST_SURFACE, true, bhv_trollface_init, bhv_trollface_loop)

--- @param o Object
local function bhv_water_loop(o)
    o.oPosY = gGlobalSyncTable.waterLevel

    if gNetworkPlayers[0].currLevelNum == gLevels[gGlobalSyncTable.level].level then -- E_MODEL_FLOOD enhacement
    cur_obj_scale(5)
    end
end

id_bhvWater = hook_behavior(nil, OBJ_LIST_SURFACE, true, bhv_water_init, bhv_water_loop)


--- @param o Object
local function bhv_custom_static_object_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    o.header.gfx.skipInViewCheck = true
    set_override_far(50000)
end

id_bhvCustomStaticObject = hook_behavior(nil, OBJ_LIST_LEVEL, true, bhv_custom_static_object_init, nil)


--- @param o Object
local function bhv_final_star_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    o.hitboxRadius = 160
    o.hitboxHeight = 100

    cur_obj_scale(2)
end

--- @param o Object
local function bhv_final_star_loop(o)
    o.oFaceAngleYaw = o.oFaceAngleYaw + 0x800
end

id_bhvFinalStar = hook_behavior(nil, OBJ_LIST_GENACTOR, true, bhv_final_star_init, bhv_final_star_loop)


--- @param o Object
local function bhv_flood_flag_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    o.oInteractType = INTERACT_POLE
    o.hitboxRadius = 80
    o.hitboxHeight = 700
    o.oIntangibleTimer = 0
    o.oAnimations = gObjectAnimations.koopa_flag_seg6_anims_06001028

    cur_obj_init_animation(0)
end

--- @param o Object
local function bhv_flood_flag_loop(o)
    bhv_pole_base_loop()
end

id_bhvFloodFlag = hook_behavior(nil, OBJ_LIST_POLELIKE, true, bhv_flood_flag_init, bhv_flood_flag_loop)

local function bhv_launchpad_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    o.oCollisionDistance = 500
    o.collisionData = COL_LAUNCHPAD
    obj_scale(o, 0.85)
end

local function bhv_launchpad_loop(o)
    local m = nearest_mario_state_to_object(o)
    if m.marioObj.platform == o then
        play_mario_jump_sound(m)
        if o.oBehParams2ndByte ~= 255 then
            set_mario_action(m, ACT_TWIRLING, 0)
            m.vel.y = o.oBehParams2ndByte
        else
            spawn_non_sync_object(
                id_bhvWingCap,
                E_MODEL_NONE,
                m.pos.x + m.vel.x, m.pos.y + m.vel.y, m.pos.z + m.vel.z,
                nil
            )
            set_mario_action(m, ACT_FLYING_TRIPLE_JUMP, 0)
            mario_set_forward_vel(m, 100)
            vec3f_set(m.angleVel, 0, 0, 0)
            vec3f_set(m.faceAngle, 0, 0x4500, 0)
            m.vel.y = 55
        end
    end
    load_object_collision_model()
end

id_bhvLaunchpad = hook_behavior(nil, OBJ_LIST_SURFACE, true, bhv_launchpad_init, bhv_launchpad_loop)

-- :[

local function bhv_up_platform1_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    o.oCollisionDistance = 7000
    o.collisionData = COL_UP_PLATFORM1
    o.oAngleVelYaw = 0
    o.header.gfx.skipInViewCheck = true
    obj_scale(o, 1)
end

local function bhv_up_platform1_loop(o)
    load_object_collision_model()
    o.oFaceAngleYaw = o.oFaceAngleYaw + math.abs(math.sin(o.oTimer / 32) * 512)
    o.oAngleVelYaw = math.abs(math.sin(o.oTimer / 32) * 512)
    if o.oAngleVelYaw <= 10 then
        local_play(sUpPlatformMove, { x = o.oPosX, y = o.oPosY, z = o.oPosZ }, 1)
    end
end

local function bhv_baseplatform_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    o.oCollisionDistance = 7000
    o.collisionData = COL_BASE
    obj_scale(o, 1)
end

local function bhv_baseplatform_loop(o)
    load_object_collision_model()
end

id_bhvBasePlatform = hook_behavior(nil, OBJ_LIST_SURFACE, true, bhv_baseplatform_init, bhv_baseplatform_loop)
id_bhvUpRotatingPlatform = hook_behavior(nil, OBJ_LIST_SURFACE, true, bhv_up_platform1_init, bhv_up_platform1_loop)

-- :]

-- everything beyond this point is default code for flood

--- @param o Object
local function obj_hide(o)
    o.header.gfx.node.flags = o.header.gfx.node.flags | GRAPH_RENDER_INVISIBLE
end

--- @param o Object
local function obj_mark_for_deletion_on_sync(o)
    if gNetworkPlayers[0].currAreaSyncValid then obj_mark_for_deletion(o) end
end

-- Objects deletion

hook_behavior(id_bhvStar,                OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvHoot,                OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvBalconyBigBoo,       OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvWaterLevelDiamond,   OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvKoopaRaceEndpoint,   OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvCapSwitch,           OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvCapSwitchBase,       OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvRacingPenguin,       OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvHiddenStar,          OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvSpawnedStar,         OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvUnusedFakeStar,      OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvFakeStar,            OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvHiddenRedCoinStar,   OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvHiddenStarTrigger,   OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvRedCoinStarMarker,   OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvOpenableGrill,       OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvToadMessage,         OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvBubba,               OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvBub,                 OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvBowser,              OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvWhompKingBoss,       OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
hook_behavior(id_bhvKoopa,               OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)

if game ~= GAME_SUPER_LUIGI_64_THE_FLOWER_CUP then
hook_behavior(id_bhvChainChompGate, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
end

if game ~= GAME_BEAT_BLOCK_BEATDOWN then
hook_behavior(id_bhvKingBobomb, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)
end

-- Objects desync
local function obj_desyncs()
local spawn_non_sync_object = spawn_non_sync_object
    local obj = spawn_non_sync_object(id_bhvCannon,         E_MODEL_CANNON_BASE,     0, 0, 0, nil)
    local obj = spawn_non_sync_object(id_bhvCannonBarrel,   E_MODEL_CANNON_BARREL,   0, 0, 0, nil)	
    local obj = spawn_non_sync_object(id_bhvHiddenBlueCoin, E_MODEL_BLUE_COIN,       0, 0, 0, nil)	
    local obj = spawn_non_sync_object(id_bhvExclamationBox, E_MODEL_EXCLAMATION_BOX, 0, 0, 0, nil)	
	
    if not obj then return nil end

    obj_copy_pos_and_angle(obj, parent)
    return obj
end

--- @param m MarioState
local function before_phys_step(m)
    if m.playerIndex ~= 0 then return end

    if m.pos.y + 40 < gGlobalSyncTable.waterLevel and gNetworkPlayers[m.playerIndex].currLevelNum == gLevels[gGlobalSyncTable.level].level then
        m.vel.y = m.vel.y + 2
        m.peakHeight = m.pos.y
    end
end

--- @param m MarioState
--- @param o Object
local function allow_interact(m, o)
    -- don't let spectators interact and don't allow warp interactions	
    if m.action == ACT_SPECTATOR or m.action == ACT_FOLLOW_SPECTATOR or
    (o.header.gfx.node.flags & GRAPH_RENDER_ACTIVE) == 0 or
    o.oInteractType == INTERACT_WARP_DOOR and gNetworkPlayers[0].currLevelNum ~= 29 
	and gNetworkPlayers[0].currLevelNum ~= 17 
	and gNetworkPlayers[0].currLevelNum ~= 11 or
    o.oInteractType == INTERACT_WARP
    and gNetworkPlayers[0].currLevelNum ~= 17 
	and gNetworkPlayers[0].currLevelNum ~= 18 
	and gNetworkPlayers[0].currLevelNum ~= 9 
	and gNetworkPlayers[0].currLevelNum ~= 12
	and gNetworkPlayers[0].currLevelNum ~= 4 
	and gNetworkPlayers[0].currLevelNum ~= 20	
	and gNetworkPlayers[0].currLevelNum ~= 19	
	and gNetworkPlayers[0].currLevelNum ~= 31
	and gNetworkPlayers[0].currLevelNum ~= 36	
	and gNetworkPlayers[0].currLevelNum ~= 21	
	and gNetworkPlayers[0].currLevelNum ~= 14
	and gNetworkPlayers[0].currLevelNum ~= 29	
	and gNetworkPlayers[0].currLevelNum ~= 24	
	and gLevels[gGlobalSyncTable.level].level ~= 16	
    and gNetworkPlayers[0].currLevelNum ~= 11 then	
	return false
end
    
	-- specific warp interactions deletions
    if o.oInteractType == INTERACT_WARP then
        if gNetworkPlayers[0].currLevelNum == LEVEL_JRB and game == GAME_THROUGH_THE_AGES
        or gNetworkPlayers[0].currLevelNum == LEVEL_TTM and game == GAME_STAR_REVENGE_4_9
        or game == GAME_MOONSHINE then	
	return false
	    end
    end

    -- check if the object is a player that's a spectator as well
    if o.behavior == get_behavior_from_id(id_bhvMario) then
        for i = 0, MAX_PLAYERS - 1 do
            if gMarioStates[i].marioObj == o then
                local oM = gMarioStates[i]

                if oM.action == ACT_SPECTATOR or oM.action == ACT_FOLLOW_SPECTATOR then
                    return false
                end
            end
        end
    end
end

local function on_pause_exit()
    if network_is_server() or network_is_moderator() then
        network_send(true, { restart = true })
        level_restart()
    end

    return false
end

--- @param m MarioState
local function allow_hazard_surface(m)
    if m.health <= 0xFF then return false end
    return true
end

-- thanks Peachy
--- @param o Object
local function on_object_unload(o)
    local m = gMarioStates[0]
    if gGlobalSyncTable.modif_coinless == true then	
        if (o.header.gfx.node.flags & GRAPH_RENDER_INVISIBLE) == 0 and o.oInteractType == INTERACT_COIN and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and obj_check_hitbox_overlap(o, m.marioObj) then
	    network_play(sCoindie, m.pos, 1.2, m.playerIndex)		
		end
    end
end

local function on_packet_receive(dataTable)
    if dataTable.restart then level_restart() end
end

function wrapNumber(num, max)
    return (num % (max + 1) + max + 1) % (max + 1)
end

hook_event(HOOK_BEFORE_PHYS_STEP, before_phys_step)
hook_event(HOOK_ALLOW_INTERACT, allow_interact)
hook_event(HOOK_ON_PAUSE_EXIT, on_pause_exit)
hook_event(HOOK_ALLOW_HAZARD_SURFACE, allow_hazard_surface)
hook_event(HOOK_ON_OBJECT_UNLOAD, on_object_unload)
hook_event(HOOK_ON_PACKET_RECEIVE, on_packet_receive)